/*
 * Decompiled with CFR 0.152.
 */
package mc.ambientocclusion.xrayinstaller.gui;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetAdapter;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.OverlayLayout;
import javax.swing.SwingWorker;
import mc.ambientocclusion.xray.XRayCore;
import mc.ambientocclusion.xrayinstaller.gui.MinecraftProfile;
import mc.ambientocclusion.xrayinstaller.gui.ModsList;
import mc.ambientocclusion.xrayinstaller.gui.Patcher;
import mc.ambientocclusion.xrayinstaller.gui.ProfileLoader;
import mc.ambientocclusion.xrayinstaller.gui.XRayInstaller;

public final class XRayInstallerGUI
extends JFrame {
    protected JButton btnPatch = new JButton("Install");
    protected JComboBox profilesList = new JComboBox();
    protected JTextField newVersion = new JTextField(String.valueOf(XRayInstaller.targetVersion) + "-XRay");
    protected JLabel loadingLabel = new JLabel(new ImageIcon(this.getClass().getResource("loader.gif")));
    private JPanel profiles = new JPanel();
    private Patcher patcher = null;
    private ModsList modsPanel = new ModsList();

    /*
     * WARNING - void declaration
     */
    public XRayInstallerGUI() {
        void var3_3;
        void var2_2;
        XRayInstallerGUI xRayInstallerGUI;
        this.setTitle(String.format("[v%s] XRay Installer", XRayCore.getVersionString()));
        this.setDefaultCloseOperation(0);
        this.setLocationRelativeTo(null);
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(this){
            private /* synthetic */ XRayInstallerGUI this$0;
            {
                this.this$0 = xRayInstallerGUI;
            }

            @Override
            public final void windowClosing(WindowEvent e) {
                if (this.this$0.patcher == null || !this.this$0.patcher.isDone()) {
                    System.exit(0);
                }
            }
        });
        JLabel label1 = new JLabel("Select the Minecraft profile you would like to mod:");
        JLabel label2 = new JLabel("Enter a name for the new modded profile:");
        label1.setAlignmentX(0.5f);
        label2.setAlignmentX(0.5f);
        this.loadingLabel.setEnabled(false);
        this.loadingLabel.addPropertyChangeListener(new PropertyChangeListener(this){
            private /* synthetic */ XRayInstallerGUI this$0;
            {
                this.this$0 = xRayInstallerGUI;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void propertyChange(PropertyChangeEvent evt) {
                if (evt.getPropertyName().equals("enabled")) {
                    void var1_1;
                    this.this$0.loadingLabel.setVisible((Boolean)evt.getNewValue());
                    this.this$0.btnPatch.setEnabled((Boolean)evt.getNewValue() == false);
                    this.this$0.profilesList.setEnabled((Boolean)evt.getNewValue() == false);
                    this.this$0.newVersion.setEnabled((Boolean)var1_1.getNewValue() == false);
                }
            }
        });
        this.profilesList.addItemListener(new ItemListener(this){
            private /* synthetic */ XRayInstallerGUI this$0;
            {
                this.this$0 = xRayInstallerGUI;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    void var1_1;
                    MinecraftProfile profile = (MinecraftProfile)e.getItem();
                    this.this$0.newVersion.setEnabled(!profile.forgeProfile && !this.this$0.loadingLabel.isEnabled());
                    this.this$0.modsPanel.setEnabled(!var1_1.forgeProfile);
                }
            }
        });
        this.profiles.setLayout(new OverlayLayout(this.profiles));
        this.profiles.add(this.loadingLabel);
        this.profiles.add(this.profilesList);
        JPanel buttonsPane = new JPanel(new GridLayout());
        buttonsPane.add(this.btnPatch);
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        contentPane.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        contentPane.add(xRayInstallerGUI);
        contentPane.add(Box.createVerticalStrut(1));
        contentPane.add(this.profiles);
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add((Component)var2_2);
        contentPane.add(Box.createVerticalStrut(1));
        contentPane.add(this.newVersion);
        contentPane.add(Box.createVerticalStrut(4));
        contentPane.add(this.modsPanel);
        contentPane.add((Component)var3_3);
        this.setContentPane(contentPane);
        this.pack();
        ProfileLoader.loadProfiles(this);
        xRayInstallerGUI = this;
        new SwingWorker<Object, Object>(xRayInstallerGUI){
            private /* synthetic */ XRayInstallerGUI this$0;
            {
                this.this$0 = xRayInstallerGUI;
            }

            @Override
            public final void done() {
                try {
                    this.this$0.setIconImage((Image)this.get());
                    return;
                }
                catch (Exception exception) {
                    return;
                }
            }
        }.execute();
        this.btnPatch.addActionListener(new ActionListener(this){
            private /* synthetic */ XRayInstallerGUI this$0;
            {
                this.this$0 = xRayInstallerGUI;
            }

            @Override
            public final void actionPerformed(ActionEvent e) {
                XRayInstallerGUI.access$2(this.this$0);
            }
        });
        try {
            new DropTarget(this, 3, new DropTargetHandler(this, 0));
            this.newVersion.setDropTarget(null);
            return;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
    }

    static /* synthetic */ void access$2(XRayInstallerGUI xRayInstallerGUI) {
        xRayInstallerGUI.newVersion.setText(xRayInstallerGUI.newVersion.getText().trim());
        MinecraftProfile object2 = (MinecraftProfile)xRayInstallerGUI.profilesList.getSelectedItem();
        MinecraftProfile minecraftProfile = new MinecraftProfile(xRayInstallerGUI.newVersion.getText());
        if ((!minecraftProfile.jar.exists() && !minecraftProfile.json.exists() || JOptionPane.showConfirmDialog(xRayInstallerGUI, "<html><b>Warning: <u>" + minecraftProfile + "</u> already exists!</b><br>If you continue this will be overwritten.<br>Are you sure you want to continue?</html>", "Overwrite?", 0) == 0) && JOptionPane.showConfirmDialog(xRayInstallerGUI, "Make sure neither Minecraft nor the Minecraft Launcher are currently running.", "XRay Installer", 2, 1) == 0) {
            xRayInstallerGUI.patcher = new Patcher(object2, minecraftProfile);
            xRayInstallerGUI.patcher.addPropertyChangeListener(new PropertyChangeListener(xRayInstallerGUI){
                private /* synthetic */ XRayInstallerGUI this$0;
                {
                    this.this$0 = xRayInstallerGUI;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public final void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("state")) {
                        void var1_1;
                        if (evt.getNewValue().equals((Object)SwingWorker.StateValue.STARTED)) {
                            this.this$0.loadingLabel.setEnabled(true);
                        }
                        if (var1_1.getNewValue().equals((Object)SwingWorker.StateValue.DONE)) {
                            this.this$0.dispose();
                        }
                    }
                }
            });
            for (File file : xRayInstallerGUI.modsPanel.getItems()) {
                xRayInstallerGUI.patcher.addSource(file);
            }
            xRayInstallerGUI.patcher.execute();
        }
    }

    private final class DropTargetHandler
    extends DropTargetAdapter {
        private /* synthetic */ XRayInstallerGUI this$0;

        private DropTargetHandler(XRayInstallerGUI xRayInstallerGUI) {
            this.this$0 = xRayInstallerGUI;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void drop(DropTargetDropEvent dtde) {
            void var1_1;
            Transferable transferable = dtde.getTransferable();
            if (dtde.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                dtde.acceptDrop(dtde.getDropAction());
                try {
                    try {
                        for (File f : (List)transferable.getTransferData(DataFlavor.javaFileListFlavor)) {
                            void var2_2;
                            String name = f.getName().toLowerCase();
                            if (!name.endsWith(".jar") && !name.endsWith(".zip")) continue;
                            this.this$0.modsPanel.addItem((File)var2_2);
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        dtde.dropComplete(true);
                        return;
                    }
                }
                finally {
                    dtde.dropComplete(true);
                }
                return;
            }
            var1_1.rejectDrop();
        }

        /* synthetic */ DropTargetHandler(XRayInstallerGUI xRayInstallerGUI, byte by) {
            this(xRayInstallerGUI);
        }
    }
}

